#!/bin/bash --login
#SBATCH -p multicore       # Use the AMD 168-core compute nodes
#SBATCH -n ?               # Specify the number of cores you want to use (change the ?)
#SBATCH -t 20              # Wallclock time limit. 20 is 20 minutes.
#SBATCH --reservation=course      # Use only during a taught course session. Delete otherwise.

# Set up to use OpenFOAM (the 'source' command is specific to OpenFOAM.)
module purge
module load apps/gcc/openfoam/v2012
source $foamDotFile

### This OpenFOAM job requires us to run two different apps ###

# Note: The number of cores *must* match the settings in the system/decomposeParDict file.
#       Our file is setup to use 4 cores.

# First split the mesh in to parts for each core to work on
mpirun redistributePar -decompose -parallel

# This is the main OpenFOAM solver (most of the runtime is spent here)
mpirun interFoam -parallel

