#!/bin/bash --login
#SBATCH -p serial      # Use the Intel nodes used for serial jobs
#SBATCH -n 1           # Optional for serial jobs - will always be 1 core
#SBATCH -t 5           # Wallclock time limit. 5 is 5 minutes.
#SBATCH --reservation=course      # Use only during a taught course session. Delete otherwise.

# Set up to use OpenFOAM (the 'source' command is specific to OpenFOAM.)
module purge
module load apps/gcc/openfoam/v2012
source $foamDotFile

# We are also going to use paraview to generate an animation.
# Note this version does not use the Paraview GUI (it is for batch jobs only).
module load apps/binapps/paraview/5.9.0

# Use OpenFOAM to combine the decomposed solution in to one mesh per time-step
reconstructPar

# Convert OpenFOAM data to VTK
foamToVTK

# Now render each time-step's mesh as a frame in an animation.
# Can request .avi or .ogv files.
pvbatch foam-anim.py foam-anim.ogv

